// グローバル変数
var sav;
var ram;

window.onload = function()
{
	// GUIの処理

	$(".menu_button").hover
	(
		function()
		{
			// 明るい画像にする
			var j_img = $("img", this);
			j_img.attr("src", j_img.attr("src").replace("_1.png", "_2.png"));
		},
		function()
		{
			// 暗い画像にする
			var j_img = $("img", this);
			j_img.attr("src", j_img.attr("src").replace("_2.png", "_1.png"));
		}
	);
	
	$(tokage.NEXT_DIV).click
	(
		function(e)
		{
			var j = $(this);
			
			if (j.css("display") !== "none" && ram.stopping && sav.stopTagName === "l")
			{
				j.css("display", "none");
				
				// アイコンを消す
				$(".click_icon").remove();
				
				sav.stopTagName = null;
				ram.stopping = false;
				setTimeout(loop, 10); // 始動
			}
		}
	);
	
	// スキップボタン
	$("#skip_button").click
	(
		function(e)
		{
			if (ram.skipMode)
			{
				ram.skipMode = false;
				var j_img = $("img", this);
				j_img.attr("src", "./data/system/skip_button_2.png");
			}
			else
			{
				ram.skipMode = true;
				var j_img = $("img", this);
				j_img.attr("src", "./data/system/skip_button_3.png");
				
				var j = $(tokage.NEXT_DIV);
				if (j.css("display") !== "none" && sav.stopTagName === "l")
				{
					j.click();
				}
			}
		}
	);
	
	// ロードボタン
	$("#load_button").click
	(
		function(e)
		{
			// ↓[s]でもロードしたいのでダメ
			// if ( $(tokage.NEXT_DIV).css("display") === "none" ) return;
			if (!ram.stopping) return;
			if (ram.skipMode) return; // 上で弾かれるハズだが一応
			if (sav.stopTagName == null) return;
			
			// 各セーブデータの概要を読み込む
			$(".savedata_row").each
			(
				function()
				{
					var number = parseInt( $(this).attr("data-number") );
					var sav_tmp = tokage.data.load(number);
					$(".savedata_image > img", this).attr("src", sav_tmp.summary.screenShot.storage);
					$(".savedata_date", this).html(sav_tmp.summary.dateTime);
					$(".savedata_chapter", this).text(sav_tmp.summary.chapter);
					
					// 空のデータの場合
					if (sav_tmp.saved == false)
					{
						$(this).addClass("notsaved");
					}
					else
					{
						$(this).removeClass("notsaved");
					}
				}
			);
			
			$("#savedata_div").css("display", "table");
			$("#hide_savedata_div").css("display", "block");
			
			// ロードとして開いていることを識別するため
			$("#savedata_div").attr("mode", "load");
		}
	);
	
	$("#hide_savedata_div").click
	(
		function(e)
		{
			$("#savedata_div").css("display", "none");
			$(this).css("display", "none");
		}
	);
	
	// セーブボタン
	$("#save_button").click
	(
		function(e)
		{
			// ↓[s]でもロードしたいのでダメ
			// if ( $(tokage.NEXT_DIV).css("display") === "none" ) return;
			if (!ram.stopping) return;
			if (ram.skipMode) return; // 上で弾かれるハズだが一応
			if (sav.stopTagName == null) return;
			
			// 各セーブデータの概要を読み込む
			$(".savedata_row").each
			(
				function()
				{
					var number = parseInt( $(this).attr("data-number") );
					var sav_tmp = tokage.data.load(number);
					$(".savedata_image > img", this).attr("src", sav_tmp.summary.screenShot.storage);
					$(".savedata_date", this).html(sav_tmp.summary.dateTime);
					$(".savedata_chapter", this).text(sav_tmp.summary.chapter);
					$(this).removeClass("notsaved");
				}
			);
			
			$("#savedata_div").css("display", "table");
			$("#hide_savedata_div").css("display", "block");
			
			// セーブとして開いていることを識別するため
			$("#savedata_div").attr("mode", "save");
		}
	);
	
	// 隠すボタン
	$("#hide_button").click
	(
		function(e)
		{
			$("#message_div").css("display", "none");
			$("#reshow_div").css("display", "block");
			
			// シナリオ側からメッセージボックスの表示状態を知ることができるようにする
			sav.f.sys.messageWindowVisible = false;
		}
	);
	
	$("#reshow_div").click
	(
		function(e)
		{
			$("#message_div").css("display", "block");
			$("#reshow_div").css("display", "none");
			
			sav.f.sys.messageWindowVisible = true;
		}
	);
	
	// セーブデータ行を読み込んでtokage.SAVEDATA_NUMだけappend()する
	var savedata_row = $.ajax( { url : "./savedata_row.html", async : false } ).responseText;
	for(var i = 0; i < tokage.SAVEDATA_NUM; i++)
	{
		var j_savedata_row = $(savedata_row);
		
		j_savedata_row.attr("data-number", "" + (i+1));
		j_savedata_row.children().attr("data-number", "" + (i+1));
		
		$("#savedata_div").append(j_savedata_row);
	}
	
	$(".savedata_row").click
	(
		function(e)
		{
			if (sav.stopTagName == null) return; // 念のため
			
			var mode = $("#savedata_div").attr("mode"); // "load" | "save"
			var number = parseInt( $(this).attr("data-number") ); // 1～tokage.SAVEDATA_NUM
			
			if (mode === "load")
			{
				// 空データの場合
				if ( $(this).hasClass("notsaved") )
				{
					return;
				}
				else
				{
					sav = tokage.data.load(number);
					ram = tokage.data.generateRam(sav);
				}
			}
			else if (mode === "save")
			{
				tokage.data.save(sav, number);
			}
			
			$("#savedata_div").css("display", "none");
			$("#hide_savedata_div").css("display", "none");
		}
	)
	.hover
	(
		function()
		{
			$(this).css("background", "rgba(0,0,0,0.88)");
		},
		function()
		{
			$(this).css("background", "rgba(0,0,0,0.44)");
		}
	);
	
	// 更新履歴エリア
	$("#history_area").each
	(
		function()
		{
			var text = $.ajax( { url : "./history.txt", async : false } ).responseText;
			$(this).val(text);
		}
	);
	
	sav = tokage.data.newData();
	ram = tokage.data.generateRam(sav);
	tokage.loadScript(sav, "first.ks");
	setTimeout(loop, 10);
};

var keyDowned = false;

// キーボードイベント
document.onkeydown = function (e)
{
	// スペースキーが押されはじめの場合
	if (!keyDowned && e.keyCode == 32)
	{
		var j = $(tokage.NEXT_DIV);
		if (j.css("display") === "block")
		{
			j.click();
		}
		keyDowned = true;
	}
};

document.onkeyup = function (e)
{
	// スペースキーが離された場合
	if (e.keyCode == 32)
	{
		keyDowned = false;
	}
};

function deleteAllData()
{
	if (window.localStorage)
	{
		if (window.confirm("ブラウザに保存されているケものがたリのセーブデータを全て削除します。よろしいですか？"))
		{
			window.localStorage.clear();
		}
	}
	else
	{
		// ここは本当に最初の一回しか呼ばれないらしい。未テスト。
		window.alert("ブラウザにケものがたリのセーブデータが存在しません。");
	}
}

function loop()
{
	while(true)
	{
		var msDelay = tokage.processChar(ram, sav, loop);
		
		// 遅延0の時、setTimeoutすら使わずにループする
		if (msDelay == 0) { continue; }
		
		// 遅延1以上の時、setTimeoutで遅延呼び出しする
		else if (msDelay >= 0) { setTimeout(loop, msDelay); break; }
		
		// 遅延-1の時、停止する
		else { break; }
	}
	ram.stopping = true;
}

// [link] クリックされた時
function onLinkClick(ram, sav, storage, target)
{
	if (ram.stopping && sav.stopTagName === "s")
	{
		
		var o = { storage : storage, target : target };
		// console.log("'" + sav.script.charAt(sav.pointer) + "' (" + sav.pointer + ")");
		tokage.tag.process(ram, sav, "jump", o);
		// console.log("'" + sav.script.charAt(sav.pointer) + "' (" + sav.pointer + ")");
		
		sav.stopTagName = null;
		ram.stopping = false;
		setTimeout(loop, 10); // 始動
	}
}
